<?php 
function defaultdate()
{
	return '0000-00-00';
}
function defaultdatetime()
{
		return '0000-00-00 00:00:00';
}
function daytime()
{
	return 24*3600;	
}
function stamptodatetime($time="")
{
	if(empty($time)) $time = time();
	return date('Y-m-d H:i:s',$time);
}
function timetodatetime($time="")
{
	if(empty($time)) $time = time();
	return date('Y-m-d H:i:s',$time);
}
function strtodatetime($str="")
{
	$time = strtotime($str);
	if(empty($time)) return '';
	return date('Y-m-d H:i:s',$time);
}

function dateheuretotale($time='',$dec=1,$langue='fr')
{
	
	if(empty($time)) $time = time();
	$dec  = 3600 * $dec;
	$time = $time + $dec - date('Z');
	$return = datetotale()." - ".date('H:i',$time);
	return $return;
}
function datetotale($time='',$dec=1,$langue='fr')
{
	if(empty($time)) $time = time();
	$dec  = 3600 * $dec;
	$time = $time + $dec - date('Z');
	$mday = date('Y-m-d',$time+$dec-date('Z'));
	$day = date('Y-m-d',time()+$dec-date('Z'));
	$hday = date('Y-m-d',time()+$dec-date('Z')-(3600*24));
	$j    = date('w',$time);
	$m    = date('d',$time);
	$mois = date('n',$time);
	$an   = date('Y',$time);
	switch($j)
	{
		case 0:$jour = 'Dimanche';break;
		case 1:$jour = 'Lundi';break;
		case 2:$jour = 'Mardi';break;
		case 3:$jour = 'Mercredi';break;
		case 4:$jour = 'Jeudi';break;
		case 5:$jour = 'Vendredi';break;
		case 6:$jour = 'Samedi';break;
	}
	switch($mois)
	{
		case 1:$mois  = 'Janvier';break;
		case 2:$mois  = 'Fevrier';break;
		case 3:$mois  = 'Mars';break;
		case 4:$mois  = 'Avril';break;
		case 5:$mois  = 'Mai';break;
		case 6:$mois  = 'Juin';break;
		case 7:$mois  = 'Juillet';break;
		case 8:$mois  = 'Ao�t';break;
		case 9:$mois  = 'Septembre';break;
		case 10:$mois = 'Octobre';break;
		case 11:$mois = 'Novembre';break;
		case 12:$mois = 'Decembre';break;
	}

	return "$jour le $m $mois $an" ;
}
function nombrejour($stamp)

{

	$JOUR = 24 * 3600;

	$nb = ceil($stamp/$JOUR);

	return $nb;

}

function duree($time = 0)

{
	$sec = $time %60;
	$min = floor($time/60);
	if($min<=0) return $sec.' seconde(s)';
	else
	{
		$hour = floor($min/60);
		$min  = $min % 60;
		if($hour<=0) return $min.' minute(s)';
		else 
		{
			$jour = floor($hour/24);
			$hour  = $hour % 24;
			if($jour<=0) return $hour.' heure(s)';
			else
			{
				$autre = floor($jour/7);
				if($autre<1) return $jour.' jour(s)';
				else return ' plus d\'une semaine ';
			}
		}
	}
	return  $min;

}

function frtodate($date)

{

	$date = strtotime(implode('-',array_reverse(explode('/',$date))));

	if($date<0) return "0000-00-00";

	else return date('Y-m-d',$date);

}

function frtodatetime($date)

{

	$date = strtotime(implode('-',array_reverse(explode('/',$date))));

	if($date<0) return "0000-00-00 00:00:00";

	else return date('Y-m-d H:i:s',$date);

}

function frtostamp($date)

{

	$date = strtotime(implode('-',array_reverse(explode('/',$date))));

	if($date<0) return "0000-00-00 00:00:00";

	else return strtotime(date('Y-m-d H:i:s',$date));

}

function strtodate($str)

{

	if($str=='0000-00-00') $time = 0;

	else $time = strtotime($str);

	if(empty($time)) return false;

	return date('d/m/Y',strtotime($str));

}

function strtodateheure($str)

{

	$stime = strtotime($str);

	if(!empty($stime)) return date('d/m/Y - H:i',$stime);

}

function datetime($dec=1)

{

	$dec = intval($dec);

	return date('Y-m-d H:i:s',time() -date('Z')+$dec * 3600);

}

function dateday($dec=1)

{

	$dec = intval($dec);

	return date('Y-m-d',time() -date('Z')+$dec * 3600);

}

function mois($id)

{

	$id = intval($id);

	switch($id)

	{

		case 1: $val =  'Janvier';break;

		case 2: $val = 'F�vrier';break;

		case 3: $val = 'Mars';break;

		case 4: $val = 'Avril';break;

		case 5: $val = 'Mai';break;

		case 6: $val = 'Juin';break;

		case 7: $val = 'Juillet';break;

		case 8: $val = 'Ao�t';break;

		case 9: $val = 'Septembre';break;

		case 10: $val = 'Octobre';break;

		case 11: $val = 'Novembre';break;

		case 12: $val = 'Decembre';break;

		default : return false;	

	}

	return encode($val);

}
function datejour($str,$dec=1)
{
	$time = strtotime($str);

	if(empty($time) or $str=='0000-00-00 00:00:00') return '-';
	$delta = time() - $time;
	$day = date('Y-m-d',$time);
	$tday = date('Y-m-d',time() -date('Z')+$dec * 3600);
	if($day==$tday)
	{
		return 'Aujourd\'hui, '.date('H:i',$time);
	}
	elseif($delta<432000)
	{
		$W = date('w',$time);
		switch($W)
		{
			case 0: return 'Dim. '.date('H:i',$time);
			case 1: return 'Lun. '.date('H:i',$time);
			case 2: return 'Mar. '.date('H:i',$time);
			case 3: return 'Mer. '.date('H:i',$time);
			case 4: return 'Jeu. '.date('H:i',$time);
			case 5: return 'Ven. '.date('H:i',$time);
			case 6: return 'Sam. '.date('H:i',$time);
			case 7: return 'Dim'.date('H:i',$time);
		}
	}
	elseif($delta<31622400)
	{
		return date('d/m H:i',$time);
	}
	else return date('d/m/Y',$time);
}
?>