<?php
defined('BASEPATH') or exit('No direct script access allowed');

## Load environment variables
## https://github.com/vlucas/phpdotenv
// Load Composer's autoloader if not already loaded
if (file_exists(APP_BASE_PATH . '/composer/vendor/autoload.php')) {
    require_once APP_BASE_PATH . '/composer/vendor/autoload.php';
}
$dotenv = Dotenv\Dotenv::createImmutable(dirname(SERVER_BASE_PATH), '.env.viralpay');
#$dotenv->load();
$dotenv->safeLoad();
/*
* --------------------------------------------------------------------------
* Base Site URL
* --------------------------------------------------------------------------
*
* URL to your CodeIgniter root. Typically this will be your base URL,
* WITH a trailing slash:
*
*   http://example.com/
*
* If this is not set then CodeIgniter will try guess the protocol, domain
* and path to your installation. However, you should always configure this
* explicitly and never rely on auto-guessing, especially in production
* environments.
*
*/
define('APP_BASE_URL', '');

/*
* --------------------------------------------------------------------------
* Encryption Key
* IMPORTANT: Do not change this ever!
* --------------------------------------------------------------------------
*
* If you use the Encryption class, you must set an encryption key.
* See the user guide for more info.
*
* http://codeigniter.com/user_guide/libraries/encryption.html
*
* Auto added on install
*/
define('APP_ENC_KEY', '438c7735407c3283749474e3b0de8f3f');

/**
 * Database Credentials
 * The hostname of your database server
 */
define('APP_DB_HOSTNAME', $_ENV['ENV_APP_DB_HOSTNAME']);
define('APP_DB_HOSTNAME_LOG', $_ENV['ENV_APP_DB_HOSTNAME_LOG']);
/**
 * The username used to connect to the database
 */
define('APP_DB_USERNAME', $_ENV['ENV_APP_DB_USERNAME']);
define('APP_DB_USERNAME_LOG', $_ENV['ENV_APP_DB_USERNAME_LOG']);
/**
 * The password used to connect to the database
 */
define('APP_DB_PASSWORD', $_ENV['ENV_APP_DB_PASSWORD']);
define('APP_DB_PASSWORD_LOG', $_ENV['ENV_APP_DB_PASSWORD_LOG']);
/**
 * The name of the database you want to connect to
 */
define('APP_DB_NAME', $_ENV['ENV_APP_DB_NAME']);
define('APP_DB_NAME_LOG', $_ENV['ENV_APP_DB_NAME_LOG']);
define('APP_DB_NAME_BACKUP', $_ENV['ENV_APP_DB_NAME_BACKUP']);
/**
 * The name of the database you want to connect to
 */
define('APP_DB_PORT', $_ENV['ENV_APP_DB_PORT']);
define('APP_DB_PORT_LOG', $_ENV['ENV_APP_DB_PORT_LOG']);

/* APPS URLS */
define('API_URL', 'https://api.viralpay.cm/');
define('APP_WEBPAY_URL', 'https://pay.viralpay.cm/');

/**
 * @since  2.3.0
 * Database charset
 */
define('APP_DB_CHARSET', 'utf8');
/**
 * @since  2.3.0
 * Database collation
 */
define('APP_DB_COLLATION', 'utf8_general_ci');

/**
 *
 * Session handler driver
 * By default the database driver will be used.
 *
 * For files session use this config:
 * define('SESS_DRIVER', 'files');
 * define('SESS_SAVE_PATH', NULL);
 * In case you are having problem with the SESS_SAVE_PATH consult with your hosting provider to set "session.save_path" value to php.ini
 *
 */
define('SESS_DRIVER', 'database');
define('SESS_SAVE_PATH', 'sessions');

/**
 * Enables CSRF Protection
 */
define('APP_CSRF_PROTECTION', true);
