<?php

$FPDF_PATH = dirname(BASEPATH).'/'."fpdf/";
if(!empty($_SERVER['WINDIR']))
{
	$FPDF_PATH = str_replace("/","\\",$FPDF_PATH);
}

define('FPDF_PATH',$FPDF_PATH);
echo FPDF_PATH;
if(!is_file(FPDF_PATH.'fpdf.php')) echo "<font color=red>La librairie FPDF est introuvable !</font>";
else
{
	include_once(FPDF_PATH.'fpdf.php');
	class PDF extends FPDF 
	{
		
		function Header()
		{
			if($this->DefOrientation=='L')$this->margeplus = 93;
			//Logo
			$this->Image('assets/images/logo.jpg',10,8,39,39);
			$this->Ln(6);
			//Police Arial gras 15c
			$this->SetFont('Arial','',8.5);
			$this->Cell(39,39,'',0,0,'L');
			//D�calage � droite
			//Titre
			$this->SetLineWidth(.6);
			$this->SetDrawColor(227,236,253);
			$this->Cell(150+$this->margeplus,6,decode('ViralPAY TRANSFERT '.($this->textHead)),'B',0,'R');
			//Saut de ligne
			$this->Ln(15);
			
		}
		
		//Pied de page
		function Footer()
		{
			//Positionnement � 1,5 cm du bas
			$this->SetY(-18);
			//Police Arial italique 8
			$this->SetFont('Arial','I',8);
			$this->SetLineWidth(.6);
			$this->SetDrawColor(227,236,253);
			//Num�ro de page
			$this->Cell(110+$this->margeplus,10,decode('Le  '.date('d/m/Y - H:i',time()-date('Z')+3600).' GMT+1 (Heure d\'Afrique Centrale) '),'T',0,'L');
			$this->Cell(80,10,'Page '.$this->PageNo(),'T',0,'R');
		}
		function setHead($val='')
		{
			$this->textHead = $val;
		}
		function setFoot($val='')
		{
			
		}
		function table($h=array(),$v=array(),$dim=array(),$align=array())
		{
			//EN TETE DE PAGE
			$size = count($h);
			$W = 190+$this->margeplus;
			$sum = array_sum($dim);
			if(!empty($h))
			{
				for($i=0;$i<=$size;$i++)
				{
					if(empty($sum)) {$dim[$i] = round($W/$size);}
					else {$dim[$i] = round(($dim[$i] *$W)/$sum);}
					
					if(empty($align[$i])) $align[$i] = 'C';
				}
				$this->Ln();
				$this->SetFillColor(95,95,95);
				$this->SetTextColor(255,255,255);
				//$this->SetDrawColor(128,0,0);
				//$this->SetLineWidth(.1);
				$this->SetFont('Arial','B',7);
				for($i=0;$i<$size;$i++)
				{
					$pos = $dim[$i];
					$this->Cell($pos,6,$h[$i],1,0,$align[$i],1);
				}
				$this->Ln();
				$this->widths = $dim;
				$this->align = $align;
				//RESTE DES LIGNES
				//donn�es
				$this->SetFont('Arial','',9);
				$this->SetTextColor(0,0,0);
				$c1 = false;
				if(!empty($v))
				{
					foreach($v as $row)
					{
						$this->Row($row);
						$c1 = !$c1;
					}
				}
			}
			
		}
		function table2D($h=array(),$v=array(),$dim=array(),$align=array())
		{
			
		}
		function texte($val='No texte',$al='C')
		{
			$this->Ln(3);
			$this->SetFont('Arial','B',9);
			$this->SetTextColor(0,0,0);
			$this->Cell(0,17,(ucfirst($val)),0,0,$al);
		}
		function show($path='')
		{
			$this->Output($path);	
		}
		function saut()
		{
			$this->AddPage();
		}
		function graph($url,$prop=135)
		{
			$this->Ln(10);
			$X = $this->GetX();
			$Y = $this->GetY();
			$this->Image($url,$X,$Y,$prop);
		}		
		######################################################################################"
		#             FONCTION SPECIALES PDF A NE PAS UPDATE
		#########################################################################################
		function Row($data)
		{
			//Calcule la hauteur de la ligne
			$nb=0;
			for($i=0;$i<count($data);$i++)
				$nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
			$h=5*$nb;
			//Effectue un saut de page si n�cessaire
			$this->CheckPageBreak($h);
			//Dessine les cellules
			for($i=0;$i<count($data);$i++)
			{
				$w=$this->widths[$i];
				$a = 'L';
				if(!empty($this->align[$i])) $a = $this->align[$i];
				//Sauve la position courante
				$x=$this->GetX();
				$y=$this->GetY();
				//Dessine le cadre
				$this->Rect($x,$y,$w,$h);
				//Imprime le texte
				$this->MultiCell($w,5,($data[$i]),0,$a);
				//Repositionne � droite
				$this->SetXY($x+$w,$y);
			}
			//Va � la ligne
			$this->Ln($h);
		}
		function NbLines($w,$txt)
		{
			//Calcule le nombre de lignes qu'occupe un MultiCell de largeur w
			$cw=&$this->CurrentFont['cw'];
			if($w==0)
				$w=$this->w-$this->rMargin-$this->x;
			$wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
			$s=str_replace("\r",'',$txt);
			$nb=strlen($s);
			if($nb>0 and $s[$nb-1]=="\n")
				$nb--;
			$sep=-1;
			$i=0;
			$j=0;
			$l=0;
			$nl=1;
			while($i<$nb)
			{
				$c=$s[$i];
				if($c=="\n")
				{
					$i++;
					$sep=-1;
					$j=$i;
					$l=0;
					$nl++;
					continue;
				}
				if($c==' ')
					$sep=$i;
				$l+=$cw[$c];
				if($l>$wmax)
				{
					if($sep==-1)
					{
						if($i==$j)
							$i++;
					}
					else
						$i=$sep+1;
					$sep=-1;
					$j=$i;
					$l=0;
					$nl++;
				}
				else
					$i++;
			}
			return $nl;
		}
		function CheckPageBreak($h)
		{
			//Si la hauteur h provoque un d�bordement, saut de page manuel
			if($this->GetY()+$h>$this->PageBreakTrigger)
				$this->AddPage($this->CurOrientation);
		}
	}
	
}
?>
